# Simple CAPTCHA Alternative with Cloudflare Turnstile

Add Cloudflare Turnstile to WordPress, WooCommerce, Contact Forms & more.

The user-friendly, privacy-preserving reCAPTCHA alternative. 100% free!

[![WordPress Plugin Version](https://img.shields.io/wordpress/plugin/v/simple-cloudflare-turnstile?style=flat-square)](https://wordpress.org/plugins/simple-cloudflare-turnstile/)
[![WordPress Tested Up To](https://img.shields.io/wordpress/plugin/tested/simple-cloudflare-turnstile?style=flat-square)](https://wordpress.org/plugins/simple-cloudflare-turnstile/)
[![Active Installations](https://img.shields.io/wordpress/plugin/installs/simple-cloudflare-turnstile?style=flat-square)](https://wordpress.org/plugins/simple-cloudflare-turnstile/)
[![Rating](https://img.shields.io/wordpress/plugin/rating/simple-cloudflare-turnstile?style=flat-square)](https://wordpress.org/plugins/simple-cloudflare-turnstile/)
[![License: GPLv3](https://img.shields.io/badge/License-GPLv3-blue.svg?style=flat-square)](https://www.gnu.org/licenses/gpl-3.0.html)
[![Last Commit](https://img.shields.io/github/last-commit/ElliotSowersby/simple-cloudflare-turnstile?style=flat-square)](https://github.com/ElliotSowersby/simple-cloudflare-turnstile/commits/master)

</div>

---

## Description

Easily add Cloudflare Turnstile to all your WordPress website forms to protect them from spam!

A user-friendly, privacy-preserving reCAPTCHA alternative. 100% free!

### Supported Forms

You can currently enable Turnstile on the following forms:

**WordPress**

* Login Form
* Registration Form
* Password Reset Form
* Comments Form

**WooCommerce**

* Checkout
* Pay For Order
* Login Form
* Registration Form
* Password Reset Form

**Form Plugins**

* WPForms
* Fluent Forms
* Contact Form 7
* Gravity Forms
* Formidable Forms
* Forminator Forms
* Jetpack Forms
* Kadence Forms

**Other Integrations**

* Elementor Pro Forms
* Easy Digital Downloads Forms
* Paid Memberships Pro Forms
* Mailchimp for WordPress Forms
* MailPoet Forms
* BuddyPress Registration Form
* bbPress Create Topic & Reply Forms
* MemberPress Forms
* Ultimate Member Forms
* WP-Members Forms
* WP User Frontend Forms
* WP User Manager Forms
* wpDiscuz Comments Form
* CheckoutWC & Flux Checkout

This plugin is also compatible with WordPress Multisite, and most two-factor authentication (2FA) plugins.

### Other Features

The plugin includes several other features and options:

* Theme: Select the default theme for Turnstile.
* Language: Set the default language for Turnstile.
* Appearance Mode: Choose if Turnstile is always displayed, or only when an interaction is required.
* Disable Submit Button: Disable the submit button on forms until the Turnstile challenge is completed.
* Custom Error Message: Set your own custom error message for failed submissions.
* Whitelist: Prevent Turnstile from showing for logged in users, or certain IP addresses (wildcards are not supported).

### Getting Started

It's super quick and easy to get started with Cloudflare Turnstile!

1. Simply generate a "site key" and "secret key" in your Cloudflare account, and add these in the plugin settings page.
2. Select which forms Turnstile should be added to and click save.
3. Finally, click the "TEST API RESPONSE" button to make sure the Turnstile API response is working OK.
4. A new Cloudflare Turnstile challenge will then be displayed on your selected forms to protect them from spam!

For more detailed instructions, please see our [setup guide](https://elliotsowersby.com/blog/setup-guide-turnstile/?utm_source=simplecloudflareturnstile&utm_medium=readme-guide).

### What is Cloudflare Turnstile?

Cloudflare Turnstile delivers frustration-free, CAPTCHA-free web experiences to website visitors.

Turnstile stops abuse and confirms visitors are real without the data privacy concerns or awful UX that CAPTCHA thrusts on users.

Learn more here: https://www.cloudflare.com/en-gb/products/turnstile/

### Is it free to use?

Yes, this plugin is completely free with no paid version, and does not include any additional data tracking.

Cloudflare Turnstile is also a completely free service.

---

### Thanks to the Plugin Sponsors!

If this plugin helps you, or you want to support its development, please consider becoming a <a href="https://github.com/sponsors/ElliotSowersby/">GitHub Sponsor</a>.

**Gold Sponsors**

<div align="left">
	<table>
		<tr>
			<td valign="middle" style="padding-right:16px;">
				<a href="https://www.relywp.com">
				<img src="https://relywp.com/wp-content/uploads/2020/07/RelyWP-Logo-1.png" alt="RelyWP" width="150" />
				</a>
			</td>
			<td valign="middle">
				WordPress &amp; WooCommerce Plugins, and Care Plans
			</td>
		</tr>
	</table>
</div>

**Silver Sponsors**

<div align="left">
	<table>
		<tr>
			<td valign="middle" style="padding-right:16px;">
				<a href="https://www.couponaffiliates.com">
                <img src="https://couponaffiliates.com/wp-content/uploads/2021/06/couponaffiliates-logo.png" alt="RelyWP" width="150" />
				</a>
            </td>
            <td valign="middle">
				WooCommerce Affiliate Plugin
			</td>
		</tr>
	</table>
</div>

**Community Sponsors:**

<a href="https://github.com/sponsors/ElliotSowersby/">Be the first community sponsor!</a>

---

## Installation

1. Upload 'simple-cloudflare-turnstile' to the '/wp-content/plugins/' directory.
2. Activate the plugin through the 'Plugins' menu in WordPress.
3. Visit the plugin settings in WordPress admin menu at "Settings > Cloudflare Turnstile".
4. You will need to generate a "Site Key" and "Site Secret" in your Cloudflare account, then enter these in the settings page.
5. Select which forms you want to enable Turnstile on, then click the "Save Changes" button.
6. Finally, you will be required to complete a quick test of the widget by clicking "TEST API RESPONSE", to confirm it's working correctly.
7. A new Cloudflare Turnstile challenge will then be displayed on your selected forms to protect them from spam!

For more detailed instructions, please see our [setup guide](https://elliotsowersby.com/blog/setup-guide-turnstile/?utm_source=simplecloudflareturnstile&utm_medium=readme-guide).

Video walkthrough: https://www.youtube.com/watch?v=Yn8X_GsTFnU

## Frequently Asked Questions

### Do you have a setup guide?

Yes, you can view a setup guide for the plugin [here](https://elliotsowersby.com/blog/setup-guide-turnstile/?utm_source=simplecloudflareturnstile&utm_medium=readme-guide).

### Will there be more integrations be added in the future?

More integrations may be added in the future, based on user feedback. So if you have any suggestions please feel free to submit a [support topic](https://wordpress.org/support/plugin/simple-cloudflare-turnstile/#new-topic-0).

### I need help, can I get support?

Please bare in mind, the [Simple CAPTCHA Alternative with Cloudflare Turnstile](https://simpleturnstile.com/) plugin is 100% free, developed as a way to give back to the WordPress community.

You can post a support thread on the WordPress.org forums to get help from the community, and we will also keep an eye on this quite frequently, providing support and answers where possible. However, we can not guarantee an answer every single support ticket.

[Click here to create a support topic.](https://wordpress.org/support/plugin/simple-cloudflare-turnstile/#new-topic-0)

The support forums are the only place you should submit a support ticket for 100% free support from the developer and the WordPress community.

### Is the plugin free?

Yes, this plugin is completely free with no paid version, and does not include any additional data tracking.

Cloudflare Turnstile is also a completely free service.

### Is this better for Data Privacy & GDPR?

Cloudflare mentions that they "never harvest data for ad retargeting" and Turnstile "never looks for cookies (like a login cookie), or uses cookies to collect or store information of any kind".

Check out [this article](https://blog.cloudflare.com/turnstile-private-captcha-alternative/#ux-isn-t-the-only-big-problem-with-captcha-so-is-privacy) which explains more about how Turnstile has less data collection, more privacy, and same security.

View the Cloudflare [GDPR compliance](https://www.cloudflare.com/en-gb/gdpr/introduction/) and [Data Processing Addendum](https://www.cloudflare.com/en-gb/cloudflare-customer-dpa/) for more information how on they handle data.

### I see a 401 console error, is this a problem?

You can safely ignore the error.

It is requesting a “Private Access Token (PAT) Open external link” that your device or browser does not support yet.

[Click here](https://developers.cloudflare.com/turnstile/frequently-asked-questions/#i-am-seeing-a-401-error-in-your-console-during-a-turnstile-security-check-is-this-a-problem) for more information.

### Turnstile Error Codes in Browser Console

For details on errors codes being displayed in your browser console, please refer to the Cloudflare documentation [here](https://developers.cloudflare.com/turnstile/troubleshooting/client-side-errors/error-codes/).

### The Turnstile Challenge is not appearing, what should I do?

Firstly, make sure you have completed the [setup guide](https://elliotsowersby.com/blog/setup-guide-turnstile/?utm_source=simplecloudflareturnstile&utm_medium=readme-guide) correctly, and that you have completed the "TEST API RESPONSE" on the settings page.

If you are still having issues, please post a [support topic](https://wordpress.org/support/plugin/simple-cloudflare-turnstile/#new-topic-0) on the WordPress.org forums.

### How can I report security bugs?

You can report security bugs through the Patchstack Vulnerability Disclosure Program. The Patchstack team help validate, triage and handle any security vulnerabilities. [Report a security vulnerability.](https://patchstack.com/database/vdp/simple-cloudflare-turnstile)

---

## Changelog

See full changelog here: [`readme.txt`](./readme.txt).

---

## License

License: GPLv3 or later.

License URI: https://www.gnu.org/licenses/gpl-3.0.html

---

## Trademark Notice

Cloudflare, the Cloudflare logo, and Cloudflare Workers are trademarks and/or registered trademarks of Cloudflare, Inc. in the United States and other jurisdictions.

This plugin is not affiliated with, endorsed, or sponsored by Cloudflare, Inc.

---

## Other Links

Developed & maintained by [@ElliotSowersby](https://twitter.com/ElliotSowersby).

View on GitHub: https://github.com/elliotvs/simple-cloudflare-turnstile

Support forum: https://wordpress.org/support/plugin/simple-cloudflare-turnstile/

Translations: https://translate.wordpress.org/projects/wp-plugins/simple-cloudflare-turnstile/

Security Disclosure: https://patchstack.com/database/vdp/simple-cloudflare-turnstile

---

If you like this plugin, a star ⭐ is appreciated!