let gulp = require('gulp'),
	less = require('gulp-less'),
	concat = require('gulp-concat'),
	minify = require('gulp-minify-css');

// Less files to be concat and minified together for CodeMirror
let CM_LESS_PATHS = ['css/general.less'];

// All other Less files to be compiled individually (excluding CM files)
let LESS_FILES = [
	'css/code-editor-style.less',
	'css/list-table.less',
	'css/snippet-edit.less',
	'css/snippet-preview.less',
	'css/snippets-table.less'
];

/**
 * Compiles all CSS tasks: CodeMirror bundle and individual Less files.
 *
 * Execution: gulp build-css
 */
gulp.task('build-css', function (done) {
	// CodeMirror bundled CSS
	let cmTask = gulp.src(CM_LESS_PATHS)
		.pipe(less())
		.pipe(concat('less-files.less'))
		.pipe(concat('ccm.min.css'))
		.pipe(minify())
		.pipe(gulp.dest('dist/css'));

	// Individual Less files
	let lessTask = gulp.src(LESS_FILES)
		.pipe(less())
		.pipe(gulp.dest('css'));

	return Promise.all([cmTask, lessTask]).then(() => done());
});

/**
 * Watch for changes in Less files and compile automatically.
 *
 * Execution: gulp watch-css
 */
gulp.task('watch-css', function () {
	gulp.watch([...CM_LESS_PATHS, ...LESS_FILES], gulp.series('build-css'));
});